<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Citymotors
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'posts-list__item card' ); ?>>

	<?php $utility = citymotors_utility()->utility; ?>

	<div class="post-list__item-content">

		<div class="post-featured-content post-quote">

			<?php citymotors_sticky_label(); ?>

		</div><!-- .post-featured-content -->

		<?php if ( 'post' === get_post_type() ) : ?>

			<div class="entry-meta">

				<span class="post__date">
					<?php $date_visible = citymotors_is_meta_visible( 'blog_post_publish_date', 'loop' ) ? 'true' : 'false';

					$utility->meta_data->get_date( array(
						'visible' => $date_visible,
						'class'   => 'post__date-link',
						'icon'    => '<i class="material-icons">access_time</i>',
						'echo'    => true,
					) );
					?>
				</span>

				<span class="post__comments">
					<?php $comment_visible = citymotors_is_meta_visible( 'blog_post_comments', 'loop' ) ? 'true' : 'false';

					$utility->meta_data->get_comment_count( array(
						'visible' => $comment_visible,
						'class'   => 'post__comments-link',
						'icon'    => '<i class="material-icons">mode_comment</i>',
						'echo'    => true,
					) );
					?>
				</span>

			</div><!-- .entry-meta -->

		<?php endif; ?>

		<header class="entry-header">

			<?php do_action( 'cherry_post_format_quote' ); ?>

		</header><!-- .entry-header -->

		<div class="entry-content">
			<?php $blog_content = get_theme_mod( 'blog_posts_content', citymotors_theme()->customizer->get_default( 'blog_posts_content' ) );
				$length = ( 'full' === $blog_content ) ? 0 : 55;

				$utility->attributes->get_content( array(
					'length'       => $length,
					'content_type' => 'post_excerpt',
					'echo'         => true,
				) );
			?>

			<?php $utility->attributes->get_button( array(
				'class' => 'blog_more-link',
				'text'  => get_theme_mod( 'blog_read_more_text', citymotors_theme()->customizer->get_default( 'blog_read_more_text' ) ),
				'icon'  => '<i class="fa fa-angle-right"></i>',
				'html'  => '<a href="%1$s" %3$s><span class="btn__text">%4$s</span>%5$s</a>',
				'echo'  => true,
			) );
			?>

			<div class="posts-list_author">
				<?php $author_visible = citymotors_is_meta_visible( 'blog_post_author', 'loop' ) ? 'true' : 'false'; ?>

				<?php
					if ( 'true' === $author_visible ) {
						echo get_avatar( $post->post_author, 59 );
					}
				?>

				<?php $utility->meta_data->get_author( array(
					'visible' => $author_visible,
					'class'   => 'posted-by__author',
					'html'    => '<span class="posted-by">%1$s<a href="%2$s" %3$s %4$s rel="author">%5$s%6$s</a></span>',
					'echo'    => true,
				) );
				?>
			</div>

			<footer class="entry-footer">

				<?php if ( 'post' === get_post_type() ) : ?>

					<?php $tags_visible = citymotors_is_meta_visible( 'blog_post_tags', 'loop' ) ? 'true' : 'false';

					$utility->meta_data->get_terms( array(
						'visible'   => $tags_visible,
						'type'      => 'post_tag',
						'delimiter' => '&nbsp;&nbsp;&nbsp; ',
						'before'    => '<div class="post__tags">',
						'after'     => '</div>',
						'echo'      => true,
					) );
					?>

				<?php endif; ?>

				<?php citymotors_share_buttons( 'loop' ); ?>

			</footer><!-- .entry-footer -->

		</div><!-- .entry-content -->

	</div><!-- .post-list__item-content -->

</article><!-- #post-## -->
