<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Citymotors
 */
?>

<section class="error-404 not-found">
	<header class="page-header">
		<h1 class="page-title"><?php esc_html_e( '404', 'citymotors' ); ?></h1>
	</header><!-- .page-header -->

	<div class="page-content">
		<h3><?php esc_html_e( 'The page not found.', 'citymotors' ); ?></h3>
		<p class="not-found_description"><?php esc_html_e( 'The page you are looking is unavailable. Please modify your request by clicking the back button on your browser or by using the navigation links on the top of the page.', 'citymotors' ); ?></p>

		<?php get_search_form(); ?>

	</div><!-- .page-content -->
</section><!-- .error-404 -->