<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Citymotors
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php $utility = citymotors_utility()->utility; ?>

	<?php citymotors_ads_post_before_content(); ?>

	<figure class="post-thumbnail">
		<?php $utility->media->get_image( array(
				'size'        => 'citymotors-thumb-l',
				'html'        => '<img class="post-thumbnail__img wp-post-image" src="%3$s" alt="%4$s">',
				'placeholder' => false,
				'echo'        => true,
			) );
		?>

		<?php $cats_visible = citymotors_is_meta_visible( 'single_post_categories', 'single' ) ? 'true' : 'false'; ?>

		<?php $utility->meta_data->get_terms( array(
			'visible' => $cats_visible,
			'type'    => 'category',
			'icon'    => '',
			'before'  => '<div class="post__cats">',
			'after'   => '</div>',
			'echo'    => true,
			) );
		?>
	</figure><!-- .post-thumbnail -->

	<header class="entry-header">

		<?php if ( 'post' === get_post_type() ) : ?>

			<div class="entry-meta">
				<?php $author_visible = citymotors_is_meta_visible( 'single_post_author', 'single' ) ? 'true' : 'false'; ?>
				<?php $utility->meta_data->get_author( array(
					'visible' => $author_visible,
					'class'   => 'posted-by__author',
					'prefix'  => esc_html__( 'Posted by ', 'citymotors' ),
					'html'    => '<span class="posted-by">%1$s<a href="%2$s" %3$s %4$s rel="author">%5$s%6$s</a></span>',
					'echo'    => true,
				) );
				?>
				<span class="post__date">
					<?php $date_visible = citymotors_is_meta_visible( 'single_post_publish_date', 'single' ) ? 'true' : 'false';

					$utility->meta_data->get_date( array(
						'visible' => $date_visible,
						'class'   => 'post__date-link',
						'icon'    => '<i class="material-icons">access_time</i>',
						'echo'    => true,
					) );
					?>
				</span>
				<span class="post__comments">
					<?php $comment_visible = citymotors_is_meta_visible( 'single_post_comments', 'single' ) ? 'true' : 'false';

					$utility->meta_data->get_comment_count( array(
						'visible' => $comment_visible,
						'class'   => 'post__comments-link',
						'icon'    => '<i class="material-icons">mode_comment</i>',
						'echo'    => true,
					) );
					?>
				</span>
			</div><!-- .entry-meta -->

		<?php endif; ?>

		<?php $utility->attributes->get_title( array(
			'class' => 'entry-title',
			'html'  => '<h3 %1$s>%4$s</h3>',
			'echo'  => true,
		) );
		?>

	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_content(); ?>
		<?php wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links__title">' . esc_html__( 'Pages:', 'citymotors' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span class="page-links__item">',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'citymotors' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php $tags_visible = citymotors_is_meta_visible( 'single_post_tags', 'single' ) ? 'true' : 'false'; ?>

		<?php $utility->meta_data->get_terms( array(
				'visible'   => $tags_visible,
				'type'      => 'post_tag',
				'icon'      => esc_html__( 'Tags: ', 'citymotors' ),
				'before'    => '<div class="post__tags">',
				'after'     => '</div>',
				'echo'      => true,
			) );
		?>

		<div class="share_container">
			<?php esc_html_e( 'Share this post: ', 'citymotors' ); ?>
			<?php citymotors_share_buttons( 'single'); ?>
		</div>

	</footer><!-- .entry-footer -->

	<?php the_post_navigation( array(
		'next_text' => '<div class="meta-nav" aria-hidden="true">' . esc_html__( 'Next Post', 'citymotors' ) . '</div> ' . '<div class="post-title">%title</div>',
		'prev_text' => '<div class="meta-nav" aria-hidden="true">' . esc_html__( 'Previous Post', 'citymotors' ) . '</div> ' . '<div class="post-title">%title</div>'
	) ); ?>

</article><!-- #post-## -->